(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38467,       1560]*)
(*NotebookOutlinePosition[     39397,       1591]*)
(*  CellTagsIndexPosition[     39353,       1587]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Second Order Linear, Constant Coefficients", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Differential equations having this form are very important in elementary \
physics, mathematics, biology , economics, and engineering, just to give a \
partial list.  In this notebook we will examine how to manually make ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " perform the standard steps in the solution process. These are  steps \
which everyone learns and which form the basis for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s built-in differential equation solver in the constant coefficients \
linear case."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Preliminaries"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["A Linear Differential Operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Define a second order linear constant coefficients differential operator \
where we take the coefficients to be ",
  StyleBox["real",
    FontVariations->{"Underline"->True}],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, a, b, c, x, y, p]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{"a", " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"b", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(c\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(c\ y[x]\), "+", 
      RowBox[{"b", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"a", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Action of the Operator on Exp[r*x]"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This operator sends any exponential function of the form ",
  StyleBox["Exp[r*x]",
    FontWeight->"Bold"],
  " into a scalar multiple of itself:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c\ \[ExponentialE]\^\(r\ x\) + b\ \[ExponentialE]\^\(r\ x\)\ r + 
      a\ \[ExponentialE]\^\(r\ x\)\ r\^2\)], "Output"]
}, Closed]],

Cell[TextData[
"We can take a better look at the nature of the scalar multiple this way:"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c + b\ r + a\ r\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This shows us that the multiple depends on the parameter  r and, indeed, \
is a polynomial. The polynomial is called the ",
  StyleBox["characteristic polynomial",
    FontVariations->{"Underline"->True}],
  " of the operator.  Our operator was of ",
  StyleBox["second order",
    FontVariations->{"Underline"->True}],
  " (had a second derivative as its highest order derivative) and this \
polynomial is ",
  StyleBox["second order",
    FontVariations->{"Underline"->True}],
  " (is quadratic). ",
  StyleBox["This is no accident",
    FontSize->10,
    FontSlant->"Italic",
    FontVariations->{"Underline"->True}],
  StyleBox[
  ", as you should take the time to verify in the general case of higher \
order operators",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox[".",
    FontSize->10],
  ""
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solving Homogeneous Differential Equations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The homogeneous equation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["We start with the same differential operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, a, b, c]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{"a", " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"b", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(c\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(c\ y[x]\), "+", 
      RowBox[{"b", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"a", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData["But we want to study a differential equation:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\(c\ y[x]\), "+", 
        RowBox[{"b", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"a", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}]}], "==", 
      "0"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "The idea is to find all functions y[x] for which this latter equation \
holds. Recall from the above discussion that ",
  StyleBox["L[x,Exp[r*x]] ==p[r]*Exp[r*x]",
    FontWeight->"Bold"],
  ", so if we want ",
  StyleBox["L[x,Exp[r*x]] == 0",
    FontWeight->"Bold"],
  ", we can get this if and only if the polynomial equation ",
  StyleBox["p[r]==0 ",
    FontWeight->"Bold"],
  "is satisfied, because ",
  StyleBox["Exp[r*x]!=0",
    FontWeight->"Bold"],
  " for any real r, x."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic polynomial"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Apply the operator L to Exp[r*x]:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c\ \[ExponentialE]\^\(r\ x\) + b\ \[ExponentialE]\^\(r\ x\)\ r + 
      a\ \[ExponentialE]\^\(r\ x\)\ r\^2\)], "Output"]
}, Closed]],

Cell[TextData["...And isolate the coefficient of Exp[r*x]:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c + b\ r + a\ r\^2\)], "Output"]
}, Closed]],

Cell[TextData[
"We now have the characteristic polynomial, from which we get the \
characteristic equation:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic equation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c + b\ r + a\ r\^2 == 0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The polynomial equation ",
  StyleBox["p[r]==0",
    FontWeight->"Bold"],
  ", which in his case is of second order, is called the ",
  StyleBox["characteristic equation",
    FontVariations->{"Underline"->True}],
  " of our operator. It holds true for ",
  StyleBox["r=r1",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["r=r2",
    FontWeight->"Bold"],
  ", where r1 and r2 can be equal, or they can be different real numbers, or \
even complex conjugates. (This is purely a property of second degree ",
  StyleBox["polynomials",
    FontVariations->{"Underline"->True}],
  " with real coefficients.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Lots of Solutions"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Suppose that we have found that  ",
  StyleBox["y1[x]",
    FontWeight->"Bold"],
  " and ",
  StyleBox["y2[x]",
    FontWeight->"Bold"],
  " are linearly independent solutions. Then, since our operator is linear ",
  StyleBox["y[x]==A*y1[x]+B*y2[x]",
    FontWeight->"Bold"],
  " is a solution for any choice of the numbers A and B.  This latter \
property, which is strictly a property of the linearity of our operator, is \
sometimes referred to as ",
  StyleBox["superposition",
    FontVariations->{"Underline"->True}],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Kernel of the Operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This doubly infinite set of solutions is the set of all solutions of the \
homogeneous problem, and is called the ",
  StyleBox["Kernel",
    FontVariations->{"Underline"->True}],
  " or the ",
  StyleBox["Null Space",
    FontVariations->{"Underline"->True}],
  " of the operator."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples (of the theory)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData[" Distinct real roots"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[L, x, y, y1, y2, r, p, r1, r2]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["Some insight"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"This polynomial has distinct roots (if we consider r1 and r2 to be \
different):"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Collect[Expand[\((r - r1)\)\ \((r - r2)\)], r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 + r\ \((\(-r1\) - r2)\) + r1\ r2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The operator"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Define our operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{\((r1 + r2)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(r1\ r2\ y[x]\)}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(r1\ r2\ y[x]\), "-", 
      RowBox[{\((r1 + r2)\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic polynomial"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(r\ x\)\ r\^2 + \[ExponentialE]\^\(r\ x\)\ r1\ r2 - \
\[ExponentialE]\^\(r\ x\)\ r\ \((r1 + r2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 + r1\ r2 - r\ \((r1 + r2)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solve the characteristic equation"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[p[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] r1}, {r \[Rule] r2}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Capture two different solutions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({y1[x_], y2[x_]} = Exp[r\ x] /. %\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(r1\ x\), \[ExponentialE]\^\(r2\ x\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Combine them into a complete solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = {y1[x], y2[x]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(r1\ x\) + 
      c2\ \[ExponentialE]\^\(r2\ x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check that we do have a solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Check that y[x] is a solution to our differential equation for any choice of \
numbers {c1, c2}:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y] \[Equal] 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check for independence"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Are y1 and y2 independent?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[WDet[x, {y1[x], y2[x]}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(\((r1 + r2)\)\ x\)\ \((\(-r1\) + r2)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Yes, they are independent: the Wronskian of y1 and y2 is never zero since \
we assumed that ",
  StyleBox["r1!=r2",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[" Repeated real roots"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[L, x, y, r, s]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["Some insight"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Make a polynomial with a double root:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[\((r - s)\)\^2]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The operator and homogeneous equation"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"We start with a differential operator which has a double root:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, s]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"2", " ", "s", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(s\^2\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(s\^2\ y[x]\), "-", 
      RowBox[{"2", " ", "s", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]],

Cell[TextData["But we want to study a differential equation:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\(s\^2\ y[x]\), "-", 
        RowBox[{"2", " ", "s", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "==", 
      "0"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "The idea is to find all functions y[x] for which this latter equation \
holds. Recall from the above discussion that ",
  StyleBox["L[x,Exp[r*x]] ==p[r]*Exp[r*x]",
    FontWeight->"Bold"],
  ", so if we want ",
  StyleBox["L[x,Exp[r*x]] == 0",
    FontWeight->"Bold"],
  ", we can only get this if the polynomial ",
  StyleBox["p[r]==0",
    FontWeight->"Bold"],
  ", because ",
  StyleBox["Exp[r*x]!=0",
    FontWeight->"Bold"],
  " for any real r, x."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic equation"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The polynomial equation ",
  StyleBox["p[r]==0",
    FontWeight->"Bold"],
  ", has solutions r=s, s. A double root:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(r\ x\)\ r\^2 - 
      2\ \[ExponentialE]\^\(r\ x\)\ r\ s + \[ExponentialE]\^\(r\ x\)\ \
s\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2\)], "Output"]
}, Closed]],

Cell[TextData["Here is our double root:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[p[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] s}, {r \[Rule] s}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Handling the double root"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"It is clear that merely capturing two solutions as we did before will cause \
one solution to be captured twice. This is bad since we need two different ( \
actually, linearly independent) solutions:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The first solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Capturing gives one (repeated) solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({y1[x_], y2[x_]} = Exp[r\ x] /. %\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(s\ x\), \[ExponentialE]\^\(s\ x\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Seek the second solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"...So we need a different approach. This turns out to be the following. A \
polynomial p[r] has  s  as a double root if and only if both p[s]==0 and \
p'[s]==0. We exploit this fact. Take the partial derivative with respect to  \
r  of the operator applied to Exp[r*x]:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_r L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(r\ x\)\ r - 
      2\ \[ExponentialE]\^\(r\ x\)\ s + \[ExponentialE]\^\(r\ x\)\ r\^2\ x - 
      2\ \[ExponentialE]\^\(r\ x\)\ r\ s\ x + \[ExponentialE]\^\(r\ x\)\ s\^2\
\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ r - 2\ s + r\^2\ x - 2\ r\ s\ x + s\^2\ x\)], "Output"]
}, Closed]],

Cell[TextData["But observe this: No matter what x is,"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[s]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Note further that ",
  StyleBox["the operator L and the partial derivative commute",
    FontVariations->{"Underline"->True}],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\[PartialD]\_r L[x, Exp[r\ #1] &] == 
        L[x, \[PartialD]\_r Exp[r\ #1] &]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This means that ",
  StyleBox["we can interchange the order",
    FontVariations->{"Underline"->True}],
  ": apply partial derivative first or apply differential operator first.  \
Which means that the following function is a solution:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = \[PartialD]\_r Exp[r\ x] /. r \[Rule] s\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(s\ x\)\ x\)], "Output"]
}, Closed]],

Cell[TextData["We already had the solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = Exp[s\ x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(s\ x\)\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["All solutions"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["This means that this should describe all solutions:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = {y1[x], y2[x]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(s\ x\) + 
      c2\ \[ExponentialE]\^\(s\ x\)\ x\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check that we have a solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Is this a solution for all {c1,c2}?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y] \[Equal] 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData["Yes, we do have a solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check for independence"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Are y1 and y2 independent?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(WDet[x, {y1[x], y2[x]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(2\ s\ x\)\)], "Output"]
}, Closed]],

Cell[TextData["Yes: the Wronskian of y1 and y2 is never zero."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[" Conjugate Complex roots (Complex solutions)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[L, x, y, p, r, s]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["Some insight:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Make a polynomial having s+I t and s-I t as conjugate complex roots:"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[\((r - s + I\ t)\)\ \((r - s - I\ t)\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2 + t\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The operator"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Define our operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, p]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"2", " ", "s", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((s\^2 + t\^2)\)\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\((s\^2 + t\^2)\)\ y[x]\), "-", 
      RowBox[{"2", " ", "s", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Get the characteristic polynomial"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(r\ x\)\ r\^2 - 
      2\ \[ExponentialE]\^\(r\ x\)\ r\ s + \[ExponentialE]\^\(r\ x\)\ \((s\^2 \
+ t\^2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2 + t\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solve the characteristic equation"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerExpand[Solve[p[r] == 0, r]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] s - \[ImaginaryI]\ t}, {r \[Rule] 
          s + \[ImaginaryI]\ t}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Capture two different solutions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({y1[x_], y2[x_]} = Exp[r\ x] /. %\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(\((s - \[ImaginaryI]\ t)\)\ x\), \
\[ExponentialE]\^\(\((s + \[ImaginaryI]\ t)\)\ x\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[%]\)], "Input"],

Cell[BoxData[
    \({\[ExponentialE]\^\(s\ x\)\ Cos[
            t\ x] - \[ImaginaryI]\ \[ExponentialE]\^\(s\ x\)\ Sin[
            t\ x], \[ExponentialE]\^\(s\ x\)\ Cos[
            t\ x] + \[ImaginaryI]\ \[ExponentialE]\^\(s\ x\)\ Sin[
            t\ x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Combine them into a complete solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = {y1[x], y2[x]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(\((s - \[ImaginaryI]\ t)\)\ x\) + 
      c2\ \[ExponentialE]\^\(\((s + \[ImaginaryI]\ t)\)\ x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check that we do have a solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Check that y[x] is a solution to our differential equation for any choice of \
numbers {c1, c2}:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y] \[Equal] 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check for independence"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Are y1 and y2 independent?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      Det[{{y1[x], y2[x]}, \[PartialD]\_x{y1[x], y2[x]}}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ \[ImaginaryI]\ \[ExponentialE]\^\(2\ s\ x\)\ t\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Yes, they are independent: the Wronskian of y1 and y2 is never zero. (t!=0 \
since we said that the roots were ",
  StyleBox["complex",
    FontVariations->{"Underline"->True}],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[" Conjugate Complex roots (Real solutions)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[L, x, y, p, r, s, t]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["Some insight:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Make a polynomial having s+I t and s-I t as conjugate complex roots:"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[\((r - s + I\ t)\)\ \((r - s - I\ t)\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2 + t\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The operator"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Define our operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, p, r, s, t]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"2", " ", "s", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((s\^2 + t\^2)\)\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\((s\^2 + t\^2)\)\ y[x]\), "-", 
      RowBox[{"2", " ", "s", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Get the characteristic polynomial"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Exp[r\ #1] &]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(r\ x\)\ r\^2 - 
      2\ \[ExponentialE]\^\(r\ x\)\ r\ s + \[ExponentialE]\^\(r\ x\)\ \((s\^2 \
+ t\^2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Coefficient[%, Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(r\^2 - 2\ r\ s + s\^2 + t\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solve the characteristic equation"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Solve[p[r] == 0, r]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] s - \[ImaginaryI]\ t}, {r \[Rule] 
          s + \[ImaginaryI]\ t}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Capture two different solutions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({s1[x_], s2[x_]} = Exp[r\ x] /. %\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(\((s - \[ImaginaryI]\ t)\)\ x\), \
\[ExponentialE]\^\(\((s + \[ImaginaryI]\ t)\)\ x\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "But we want real solutions. In order to get them, we need to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " what is real:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(s /: Re[s] = s\), "\n", 
    \(s /: Im[s] = 0\), "\n", 
    \(t /: Re[t] = t\), "\n", 
    \(t /: Im[t] = 0\), "\n", 
    \(x /: Re[x] = x\), "\n", 
    \(x /: Im[x] = 0\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(s\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(t\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(x\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[
"Now let's get two real solutions from s1[x]. (It is clear that we would get \
the same two solutions from s2[x].)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x] = Re[s1[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(s\ x\)\ Cos[t\ x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x] = Im[s1[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\[ExponentialE]\^\(s\ x\)\)\ Sin[t\ x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Combine them into a complete solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = {y1[x], y2[x]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(s\ x\)\ Cos[t\ x] - 
      c2\ \[ExponentialE]\^\(s\ x\)\ Sin[t\ x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check that we do have a solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Check that y[x] is a solution to our differential equation for any choice of \
numbers {c1, c2}:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y] \[Equal] 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check for independence"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Are y1 and y2 independent?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[WDet[x, {y1[x], y2[x]}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\[ExponentialE]\^\(2\ s\ x\)\)\ t\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Yes, they are independent: the Wronskian of y1 and y2 is never zero. (t!=0 \
since we said that the roots were ",
  StyleBox["complex",
    FontVariations->{"Underline"->True}],
  ".) "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Summary of our discoveries"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"We therefore can get two real linearly independent solutions in each of the \
three possible cases: distinct real roots, repeated real roots, and complex \
conjugate roots."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Problems"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve these problems using the techniques described above:\n\n\[Bullet]  \
",
  StyleBox["y''[x]-y'[x]-12y[x]==0", "Input"],
  "\n\n\[Bullet]  ",
  StyleBox["y''[x]-4y[x]==0", "Input"],
  "\n\n\[Bullet]  ",
  StyleBox["y''[x]-2y'[x]+5y[x]==0", "Input"],
  "\n\n\[Bullet]  ",
  StyleBox["4y''[x]-4y'[x]+y[x]==0", "Input"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(WMatrix[x_, z_List] := 
      Table[\[PartialD]\_{x, i}z, {i, 0, Length[z] - 1}]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Off[General::"\<spell1\>"]\)], "Input"],

Cell[BoxData[
    \(WDet[x_, z_List] := Det[WMatrix[x, z]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Needs["\<Algebra`ReIm`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(On[General::"\<spell1\>"]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{590, 568},
WindowMargins->{{36, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 111, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1890, 57, 625, 14, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2540, 75, 91, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2656, 81, 111, 2, 46, "Subsection",
  Evaluatable->False],
Cell[2770, 85, 261, 8, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3056, 97, 479, 12, 43, "Input"],
Cell[3538, 111, 353, 9, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3940, 126, 115, 2, 46, "Subsection",
  Evaluatable->False],
Cell[4058, 130, 226, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4309, 141, 78, 2, 27, "Input"],
Cell[4390, 145, 140, 2, 29, "Output"]
}, Closed]],
Cell[4545, 150, 151, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4721, 158, 93, 2, 27, "Input"],
Cell[4817, 162, 52, 1, 29, "Output"]
}, Closed]],
Cell[4884, 166, 889, 27, 86, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5822, 199, 120, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5967, 205, 105, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6075, 209, 120, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6220, 215, 476, 12, 43, "Input"],
Cell[6699, 229, 353, 9, 27, "Output"]
}, Closed]],
Cell[7067, 241, 120, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7212, 247, 72, 2, 27, "Input"],
Cell[7287, 251, 404, 11, 27, "Output"]
}, Closed]],
Cell[7706, 265, 562, 17, 68, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8305, 287, 110, 2, 46, "Subsection",
  Evaluatable->False],
Cell[8418, 291, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8551, 297, 78, 2, 27, "Input"],
Cell[8632, 301, 140, 2, 29, "Output"]
}, Closed]],
Cell[8787, 306, 118, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8930, 312, 93, 2, 27, "Input"],
Cell[9026, 316, 52, 1, 29, "Output"]
}, Closed]],
Cell[9093, 320, 167, 4, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[9297, 329, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9430, 335, 69, 2, 27, "Input"],
Cell[9502, 339, 57, 1, 29, "Output"]
}, Closed]],
Cell[9574, 343, 684, 20, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10295, 368, 98, 2, 46, "Subsection",
  Evaluatable->False],
Cell[10396, 372, 610, 18, 68, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[11043, 395, 103, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11149, 399, 362, 11, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11560, 416, 102, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11687, 422, 101, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11791, 426, 69, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[11885, 431, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[11984, 435, 156, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12165, 443, 106, 2, 27, "Input"],
Cell[12274, 447, 71, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12394, 454, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[12493, 458, 95, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12613, 464, 419, 11, 27, "Input"],
Cell[13035, 477, 335, 8, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13419, 491, 113, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13557, 497, 78, 2, 27, "Input"],
Cell[13638, 501, 149, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13824, 508, 93, 2, 27, "Input"],
Cell[13920, 512, 66, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14035, 519, 117, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14177, 525, 79, 2, 27, "Input"],
Cell[14259, 529, 66, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14374, 536, 115, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14514, 542, 93, 2, 27, "Input"],
Cell[14610, 546, 90, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14749, 553, 121, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14895, 559, 93, 2, 27, "Input"],
Cell[14991, 563, 104, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15144, 571, 116, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[15263, 575, 172, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15460, 583, 88, 2, 27, "Input"],
Cell[15551, 587, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15638, 594, 106, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[15747, 598, 101, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15873, 604, 93, 2, 27, "Input"],
Cell[15969, 608, 91, 1, 29, "Output"]
}, Closed]],
Cell[16075, 612, 226, 8, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16350, 626, 101, 2, 30, "Subsection",
  Evaluatable->False],
Cell[16454, 630, 53, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[16532, 635, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[16631, 639, 112, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16768, 645, 82, 2, 31, "Input"],
Cell[16853, 649, 55, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16957, 656, 121, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[17081, 660, 138, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17244, 667, 448, 11, 45, "Input"],
Cell[17695, 680, 333, 8, 29, "Output"]
}, Closed]],
Cell[18043, 691, 120, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18188, 697, 72, 2, 27, "Input"],
Cell[18263, 701, 382, 10, 29, "Output"]
}, Closed]],
Cell[18660, 714, 533, 17, 68, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[19230, 736, 111, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[19344, 740, 196, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19565, 751, 78, 2, 27, "Input"],
Cell[19646, 755, 145, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[19828, 763, 93, 2, 27, "Input"],
Cell[19924, 767, 55, 1, 29, "Output"]
}, Closed]],
Cell[19994, 771, 99, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20118, 777, 79, 2, 27, "Input"],
Cell[20200, 781, 64, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20313, 788, 108, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[20424, 792, 275, 5, 50, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[20736, 802, 102, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[20841, 806, 115, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20981, 812, 93, 2, 27, "Input"],
Cell[21077, 816, 88, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21214, 823, 108, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[21325, 827, 345, 6, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21695, 837, 93, 2, 27, "Input"],
Cell[21791, 841, 229, 4, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[22057, 850, 93, 2, 27, "Input"],
Cell[22153, 854, 78, 1, 29, "Output"]
}, Closed]],
Cell[22246, 858, 113, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22384, 864, 64, 2, 27, "Input"],
Cell[22451, 868, 35, 1, 27, "Output"]
}, Closed]],
Cell[22501, 872, 212, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22738, 883, 149, 3, 27, "Input"],
Cell[22890, 888, 38, 1, 27, "Output"]
}, Closed]],
Cell[22943, 892, 316, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23284, 904, 108, 2, 27, "Input"],
Cell[23395, 908, 62, 1, 27, "Output"]
}, Closed]],
Cell[23472, 912, 103, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23600, 918, 78, 2, 27, "Input"],
Cell[23681, 922, 59, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23801, 930, 94, 2, 30, "Subsection",
  Evaluatable->False],
Cell[23898, 934, 126, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24049, 940, 93, 2, 27, "Input"],
Cell[24145, 944, 105, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24299, 952, 110, 2, 30, "Subsection",
  Evaluatable->False],
Cell[24412, 956, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24547, 962, 88, 2, 27, "Input"],
Cell[24638, 966, 38, 1, 27, "Output"]
}, Closed]],
Cell[24691, 970, 102, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[24830, 977, 103, 2, 30, "Subsection",
  Evaluatable->False],
Cell[24936, 981, 101, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[25062, 987, 83, 2, 27, "Input"],
Cell[25148, 991, 62, 1, 29, "Output"]
}, Closed]],
Cell[25225, 995, 121, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[25383, 1002, 125, 2, 30, "Subsection",
  Evaluatable->False],
Cell[25511, 1006, 56, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[25592, 1011, 97, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[25692, 1015, 147, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[25864, 1023, 106, 2, 27, "Input"],
Cell[25973, 1027, 62, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26084, 1034, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[26183, 1038, 95, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[26303, 1044, 461, 11, 47, "Input"],
Cell[26767, 1057, 346, 8, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27162, 1071, 117, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27304, 1077, 78, 2, 27, "Input"],
Cell[27385, 1081, 158, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[27580, 1089, 93, 2, 27, "Input"],
Cell[27676, 1093, 62, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27787, 1100, 117, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27929, 1106, 92, 2, 27, "Input"],
Cell[28024, 1110, 113, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28186, 1118, 115, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28326, 1124, 93, 2, 27, "Input"],
Cell[28422, 1128, 140, 2, 32, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[28599, 1135, 49, 1, 27, "Input"],
Cell[28651, 1138, 270, 5, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28970, 1149, 121, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29116, 1155, 93, 2, 27, "Input"],
Cell[29212, 1159, 152, 2, 30, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29413, 1167, 116, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[29532, 1171, 172, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29729, 1179, 88, 2, 27, "Input"],
Cell[29820, 1183, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29907, 1190, 106, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[30016, 1194, 101, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[30142, 1200, 128, 3, 27, "Input"],
Cell[30273, 1205, 83, 1, 29, "Output"]
}, Closed]],
Cell[30371, 1209, 264, 8, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30684, 1223, 122, 2, 30, "Subsection",
  Evaluatable->False],
Cell[30809, 1227, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[30893, 1232, 97, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[30993, 1236, 147, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31165, 1244, 106, 2, 27, "Input"],
Cell[31274, 1248, 62, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31385, 1255, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[31484, 1259, 95, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31604, 1265, 470, 11, 47, "Input"],
Cell[32077, 1278, 346, 8, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32472, 1292, 117, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[32614, 1298, 78, 2, 27, "Input"],
Cell[32695, 1302, 158, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[32890, 1310, 93, 2, 27, "Input"],
Cell[32986, 1314, 62, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33097, 1321, 117, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[33239, 1327, 89, 2, 27, "Input"],
Cell[33331, 1331, 113, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33493, 1339, 115, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[33633, 1345, 93, 2, 27, "Input"],
Cell[33729, 1349, 140, 2, 32, "Output"]
}, Closed]],
Cell[33884, 1354, 219, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[34128, 1365, 231, 7, 107, "Input"],
Cell[34362, 1374, 35, 1, 27, "Output"],
Cell[34400, 1377, 35, 1, 27, "Output"],
Cell[34438, 1380, 35, 1, 27, "Output"],
Cell[34476, 1383, 35, 1, 27, "Output"],
Cell[34514, 1386, 35, 1, 27, "Output"],
Cell[34552, 1389, 35, 1, 27, "Output"]
}, Closed]],
Cell[34602, 1393, 189, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[34816, 1401, 77, 2, 27, "Input"],
Cell[34896, 1405, 70, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[35003, 1411, 77, 2, 27, "Input"],
Cell[35083, 1415, 75, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35207, 1422, 121, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[35353, 1428, 93, 2, 27, "Input"],
Cell[35449, 1432, 124, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35622, 1440, 116, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[35741, 1444, 172, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[35938, 1452, 88, 2, 27, "Input"],
Cell[36029, 1456, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36116, 1463, 106, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[36225, 1467, 101, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[36351, 1473, 93, 2, 27, "Input"],
Cell[36447, 1477, 70, 1, 29, "Output"]
}, Closed]],
Cell[36532, 1481, 265, 8, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36846, 1495, 107, 2, 30, "Subsection",
  Evaluatable->False],
Cell[36956, 1499, 248, 5, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37253, 1510, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[37342, 1514, 400, 12, 176, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[37779, 1531, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[37874, 1535, 168, 4, 28, "Input",
  InitializationCell->True],
Cell[38045, 1541, 59, 1, 27, "Input"],
Cell[38107, 1544, 126, 3, 27, "Input",
  InitializationCell->True],
Cell[38236, 1549, 114, 3, 27, "Input",
  InitializationCell->True],
Cell[38353, 1554, 86, 2, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

